/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.gui.ChooseDir;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;
import net.ftb.util.SwingUtils;

public class EditModPackDialog
extends JDialog {
    private JTabbedPane tabbedPane;
    private JPanel formPnl;
    private JButton openFolder;
    private JButton addMod;
    private JButton disableMod;
    private JButton enableMod;
    private JLabel enabledModsLbl;
    private JLabel disabledModsLbl;
    private JScrollPane enabledModsScl;
    private JScrollPane disabledModsScl;
    private JList enabledModsLst;
    private JList disabledModsLst;
    private List<String> enabledMods;
    private List<String> disabledMods;
    private int mcversion = 0;
    private final File modsFolder = new File(Settings.getSettings().getInstallPath(), ModPack.getSelectedPack().getDir() + File.separator + "minecraft" + File.separator + "mods");
    private final File coreModsFolder = new File(Settings.getSettings().getInstallPath(), ModPack.getSelectedPack().getDir() + File.separator + "minecraft" + File.separator + "coremods");
    private final File jarModsFolder = new File(Settings.getSettings().getInstallPath(), ModPack.getSelectedPack().getDir() + File.separator + "instMods");
    public File folder = this.modsFolder;
    private Tab currentTab = Tab.MODS;

    public EditModPackDialog(LaunchFrame instance, ModPack modPack) {
        super((Frame)instance, true);
        if (modPack != null && modPack.getMcVersion() != null) {
            this.mcversion = Integer.parseInt(modPack.getMcVersion().replaceAll("[^\\d]", ""));
        }
        Logger.logInfo("MCVersion: " + this.mcversion);
        this.modsFolder.mkdirs();
        this.coreModsFolder.mkdirs();
        this.jarModsFolder.mkdirs();
        this.setupGui();
        this.enabledMods = Lists.newArrayList();
        this.disabledMods = Lists.newArrayList();
        this.tabbedPane.setSelectedIndex(0);
        this.enabledModsLst.setListData(this.getEnabled());
        this.disabledModsLst.setListData(this.getDisabled());
        this.addMod.addActionListener(new ChooseDir(this));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                EditModPackDialog.this.currentTab = Tab.values()[EditModPackDialog.this.tabbedPane.getSelectedIndex()];
                switch (EditModPackDialog.this.currentTab) {
                    case MODS: {
                        EditModPackDialog.this.folder = EditModPackDialog.this.modsFolder;
                        break;
                    }
                    case COREMODS: {
                        EditModPackDialog.this.folder = EditModPackDialog.this.coreModsFolder;
                        break;
                    }
                    case JARMODS: {
                        EditModPackDialog.this.folder = EditModPackDialog.this.jarModsFolder;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                ((JPanel)EditModPackDialog.this.tabbedPane.getSelectedComponent()).add(EditModPackDialog.this.formPnl);
                EditModPackDialog.this.updateLists();
            }
        });
        this.openFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OSUtils.open(EditModPackDialog.this.folder);
            }
        });
        this.disableMod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (EditModPackDialog.this.enabledModsLst.getSelectedIndices().length > 1) {
                    for (int i = 0; i < EditModPackDialog.this.enabledModsLst.getSelectedIndices().length; ++i) {
                        String name = (String)EditModPackDialog.this.enabledMods.get(EditModPackDialog.this.enabledModsLst.getSelectedIndices()[i]);
                        new File(EditModPackDialog.this.folder, name).renameTo(new File(EditModPackDialog.this.folder, name + ".disabled"));
                    }
                    EditModPackDialog.this.updateLists();
                } else {
                    if (EditModPackDialog.this.enabledModsLst.getSelectedIndex() >= 0) {
                        String name = (String)EditModPackDialog.this.enabledMods.get(EditModPackDialog.this.enabledModsLst.getSelectedIndex());
                        new File(EditModPackDialog.this.folder, name).renameTo(new File(EditModPackDialog.this.folder, name + ".disabled"));
                    }
                    EditModPackDialog.this.updateLists();
                }
            }
        });
        this.enableMod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (EditModPackDialog.this.disabledModsLst.getSelectedIndices().length > 1) {
                    for (int i = 0; i < EditModPackDialog.this.disabledModsLst.getSelectedIndices().length; ++i) {
                        String name = (String)EditModPackDialog.this.disabledMods.get(EditModPackDialog.this.disabledModsLst.getSelectedIndices()[i]);
                        new File(EditModPackDialog.this.folder, name).renameTo(new File(EditModPackDialog.this.folder, name.replace(".disabled", "")));
                    }
                    EditModPackDialog.this.updateLists();
                } else {
                    if (EditModPackDialog.this.disabledModsLst.getSelectedIndex() >= 0) {
                        String name = (String)EditModPackDialog.this.disabledMods.get(EditModPackDialog.this.disabledModsLst.getSelectedIndex());
                        new File(EditModPackDialog.this.folder, name).renameTo(new File(EditModPackDialog.this.folder, name.replace(".disabled", "")));
                    }
                    EditModPackDialog.this.updateLists();
                }
            }
        });
    }

    private String[] getEnabled() {
        this.enabledMods.clear();
        if (this.folder.exists()) {
            for (String name : this.folder.list()) {
                if (name.toLowerCase().endsWith(".zip")) {
                    this.enabledMods.add(name);
                    continue;
                }
                if (name.toLowerCase().endsWith(".jar")) {
                    this.enabledMods.add(name);
                    continue;
                }
                if (!name.toLowerCase().endsWith(".litemod")) continue;
                this.enabledMods.add(name);
            }
        }
        String[] enabledList = new String[this.enabledMods.size()];
        for (int i = 0; i < this.enabledMods.size(); ++i) {
            enabledList[i] = this.enabledMods.get(i).replace(".zip", "").replace(".jar", "").replace(".litemod", "");
        }
        return enabledList;
    }

    private String[] getDisabled() {
        this.disabledMods.clear();
        if (this.folder.exists()) {
            for (String name : this.folder.list()) {
                if (name.toLowerCase().endsWith(".zip.disabled")) {
                    this.disabledMods.add(name);
                    continue;
                }
                if (name.toLowerCase().endsWith(".jar.disabled")) {
                    this.disabledMods.add(name);
                    continue;
                }
                if (!name.toLowerCase().endsWith(".litemod.disabled")) continue;
                this.disabledMods.add(name);
            }
        }
        String[] enabledList = new String[this.disabledMods.size()];
        for (int i = 0; i < this.disabledMods.size(); ++i) {
            enabledList[i] = this.disabledMods.get(i).replace(".zip.disabled", "").replace(".jar.disabled", "").replace(".litemod.disabled", "");
        }
        return enabledList;
    }

    public void updateLists() {
        this.enabledModsLst.setListData(this.getEnabled());
        this.disabledModsLst.setListData(this.getDisabled());
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("MODS_EDIT_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.formPnl = new JPanel();
        this.enabledModsLbl = new JLabel(I18N.getLocaleString("MODS_EDIT_ENABLED_LABEL"));
        this.disabledModsLbl = new JLabel(I18N.getLocaleString("MODS_EDIT_DISABLED_LABEL"));
        this.openFolder = new JButton(I18N.getLocaleString("MODS_EDIT_OPEN_FOLDER"));
        this.addMod = new JButton(I18N.getLocaleString("MODS_EDIT_ADD_MOD"));
        this.disableMod = new JButton(I18N.getLocaleString("MODS_EDIT_DISABLE_MOD"));
        this.enableMod = new JButton(I18N.getLocaleString("MODS_EDIT_ENABLE_MOD"));
        this.enabledModsLst = new JList();
        this.disabledModsLst = new JList();
        this.enabledModsScl = new JScrollPane(this.enabledModsLst);
        this.disabledModsScl = new JScrollPane(this.disabledModsLst);
        panel.add(this.tabbedPane);
        this.tabbedPane.addTab(null, new JPanel(new BorderLayout()));
        if (this.mcversion <= 152) {
            this.tabbedPane.addTab(null, new JPanel(new BorderLayout()));
            this.tabbedPane.addTab(null, new JPanel(new BorderLayout()));
        }
        JLabel tabLabel = new JLabel("Mods");
        tabLabel.setBorder(new EmptyBorder(8, 15, 5, 15));
        this.tabbedPane.setTabComponentAt(0, tabLabel);
        if (this.mcversion <= 152) {
            tabLabel = new JLabel("JarMods");
            tabLabel.setBorder(new EmptyBorder(8, 15, 5, 15));
            this.tabbedPane.setTabComponentAt(1, tabLabel);
            tabLabel = new JLabel("CoreMods");
            tabLabel.setBorder(new EmptyBorder(8, 15, 5, 15));
            this.tabbedPane.setTabComponentAt(2, tabLabel);
        }
        this.enabledModsLbl.setHorizontalAlignment(0);
        this.disabledModsLbl.setHorizontalAlignment(0);
        this.enabledModsLbl.setFont(this.enabledModsLbl.getFont().deriveFont(1, 22.0f));
        this.disabledModsLbl.setFont(this.disabledModsLbl.getFont().deriveFont(1, 22.0f));
        this.enabledModsLst.setBackground(UIManager.getColor("control").darker().darker());
        this.disabledModsLst.setBackground(UIManager.getColor("control").darker().darker());
        this.enabledModsScl.setViewportView(this.enabledModsLst);
        this.disabledModsScl.setViewportView(this.disabledModsLst);
        SpringLayout layout = new SpringLayout();
        this.formPnl.setLayout(layout);
        this.formPnl.add(this.enabledModsLbl);
        this.formPnl.add(this.disabledModsLbl);
        this.formPnl.add(this.enabledModsScl);
        this.formPnl.add(this.disabledModsScl);
        this.formPnl.add(this.disableMod);
        this.formPnl.add(this.enableMod);
        this.formPnl.add(this.addMod);
        this.formPnl.add(this.openFolder);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.enabledModsLbl, vSpring, "North", (Component)this.formPnl);
        layout.putConstraint("North", (Component)this.disabledModsLbl, vSpring, "North", (Component)this.formPnl);
        Spring rowHeight = Spring.height(this.enabledModsLbl);
        rowHeight = Spring.max(rowHeight, Spring.height(this.disabledModsLbl));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("North", (Component)this.enabledModsScl, vSpring, "North", (Component)this.formPnl);
        layout.putConstraint("North", (Component)this.disabledModsScl, vSpring, "North", (Component)this.formPnl);
        rowHeight = Spring.constant(320);
        Spring buttonRowHeight = SwingUtils.springSum(Spring.scale(rowHeight, 0.5f), Spring.minus(Spring.height(this.enableMod)), Spring.minus(Spring.constant(5)));
        layout.putConstraint("South", (Component)this.enableMod, Spring.sum(vSpring, buttonRowHeight), "North", (Component)this.formPnl);
        buttonRowHeight = Spring.sum(buttonRowHeight, Spring.constant(10));
        layout.putConstraint("North", (Component)this.disableMod, Spring.sum(vSpring, buttonRowHeight), "North", (Component)this.formPnl);
        vSpring = Spring.sum(vSpring, rowHeight);
        layout.putConstraint("South", (Component)this.enabledModsScl, vSpring, "North", (Component)this.formPnl);
        layout.putConstraint("South", (Component)this.disabledModsScl, vSpring, "North", (Component)this.formPnl);
        vSpring = Spring.sum(vSpring, Spring.constant(10));
        layout.putConstraint("North", (Component)this.addMod, vSpring, "North", (Component)this.formPnl);
        layout.putConstraint("North", (Component)this.openFolder, vSpring, "North", (Component)this.formPnl);
        rowHeight = Spring.max(Spring.height(this.addMod), Spring.height(this.openFolder));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)this.formPnl, vSpring, "North", (Component)this.formPnl);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.enabledModsLbl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("West", (Component)this.enabledModsScl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("West", (Component)this.openFolder, hSpring, "West", (Component)this.formPnl);
        Spring columnWidth = SwingUtils.springMax(Spring.width(this.enabledModsLbl), Spring.width(this.disabledModsLbl), Spring.constant(260));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.enabledModsLbl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("East", (Component)this.enabledModsScl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("East", (Component)this.openFolder, hSpring, "West", (Component)this.formPnl);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("West", (Component)this.enableMod, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("West", (Component)this.disableMod, hSpring, "West", (Component)this.formPnl);
        Spring buttonColumnWidth = Spring.max(Spring.width(this.enableMod), Spring.width(this.disableMod));
        hSpring = Spring.sum(hSpring, buttonColumnWidth);
        layout.putConstraint("East", (Component)this.enableMod, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("East", (Component)this.disableMod, hSpring, "West", (Component)this.formPnl);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("West", (Component)this.disabledModsLbl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("West", (Component)this.disabledModsScl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("West", (Component)this.addMod, hSpring, "West", (Component)this.formPnl);
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.disabledModsLbl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("East", (Component)this.disabledModsScl, hSpring, "West", (Component)this.formPnl);
        layout.putConstraint("East", (Component)this.addMod, hSpring, "West", (Component)this.formPnl);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)this.formPnl, hSpring, "West", (Component)this.formPnl);
        ((JPanel)this.tabbedPane.getComponent(0)).add(this.formPnl);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static enum Tab {
        MODS,
        JARMODS,
        COREMODS,
        OLD_VERSIONS;

    }
}

